#include "stdafx.h"

int main(int argc, char* argv[]) {
  Env = TEnv(argc, argv, TNotify::StdNotify);
  Env.PrepArgs(TStr::Fmt("Network community detection. build: %s, %s. Time: %s", __TIME__, __DATE__, TExeTm::GetCurTm()));
  TExeTm ExeTm;
  Try
  const TStr InFNm = Env.GetIfArgPrefixStr("-i:", "graph.txt", "Input graph (undirected graph)");
  const TStr OutFNm = Env.GetIfArgPrefixStr("-o:", "communities.txt", "Output file");
  const int CmtyAlg = Env.GetIfArgPrefixInt("-a:", 2, "Algorithm: 1:Girvan-Newman, 2:Clauset-Newman-Moore");
  
  //PUNGraph Graph = TSnap::LoadEdgeList<PUNGraph>(InFNm, false); 
  PUNGraph Graph = TSnap::LoadEdgeList<PUNGraph>("../as20graph.txt", false); 
  
  //PUNGraph Graph = TSnap::GenRndGnm<PUNGraph>(5000, 10000);  
  TSnap::DelSelfEdges(Graph);
  TCnComV CmtyV;
  double Q = 0.0;
  TStr CmtyAlgStr;
  if (CmtyAlg == 1) { 
    CmtyAlgStr = "Girvan-Newman";
    Q = TSnap::CommunityGirvanNewman(Graph, CmtyV); }
  else if (CmtyAlg == 2) { 
    CmtyAlgStr = "Cluset-Newman-Moore";
    Q = TSnap::CommunityCNM(Graph, CmtyV); }
  else { Fail; }

  FILE *F = fopen(OutFNm.CStr(), "wt");
  fprintf(F, "# Input: %s\n", InFNm.CStr());
  fprintf(F, "# Nodes: %d    Edges: %d\n", Graph->GetNodes(), Graph->GetEdges());
  fprintf(F, "# Algoritm: %s\n", CmtyAlgStr.CStr());
  fprintf(F, "# Modularity: %f\n", Q);
  fprintf(F, "# Communities: %d\n", CmtyV.Len());
  fprintf(F, "# NId\tCommunityId\n");
  for (int c = 0; c < CmtyV.Len(); c++) {
    for (int i = 0; i < CmtyV[c].Len(); i++) {
      fprintf(F, "%d\t%d\n", CmtyV[c][i], c); 
    }
  }
  fclose(F);

  //PUNGraph Graph = TSnap::LoadEdgeList<PUNGraph>("/xOldSVN/Projects/NCP/ModulClust/package/karate.txt");
  /*PUNGraph Graph = TUNGraph::New();
  for (int i = 0; i < 12; i++) { Graph->AddNode(i); }
  Graph->AddEdge(0,1); Graph->AddEdge(0,2); Graph->AddEdge(0,3); Graph->AddEdge(1,2); Graph->AddEdge(1,3); Graph->AddEdge(2,3);  
  Graph->AddEdge(4+0,4+1); Graph->AddEdge(4+0,4+2); Graph->AddEdge(4+0,4+3); Graph->AddEdge(4+1,4+2); Graph->AddEdge(4+1,4+3); Graph->AddEdge(4+2,4+3);  
  Graph->AddEdge(8+0,8+1); Graph->AddEdge(8+0,8+2); Graph->AddEdge(8+0,8+3); Graph->AddEdge(8+1,8+2); Graph->AddEdge(8+1,8+3); Graph->AddEdge(8+2,8+3);  
  Graph->AddEdge(3,4);
  Graph->AddEdge(7,8);
  //*/
  //TCnComV CmtyV;
  //TSnap::CommunityGirvanNewman(Graph, CmtyV);
  //TSnap::CommunityCNM(Graph, CmtyV);
  //printf("*** time %f\n", ExeTm.GetSecs()); ExeTm.Tick();
  
  //printf("*** time %f\n", ExeTm.GetSecs()); ExeTm.Tick();

  /*TIntPrFltH BtwEH;
  TSnap::GetBetweennessCentr(Graph, BtwEH);
  BtwEH.SortByDat(false);
  for (int i = 0; i < BtwEH.Len(); i++) {
    printf("%2d-%2d\t%f\n", BtwEH.GetKey(i).Val1, BtwEH.GetKey(i).Val2, BtwEH[i]);
  }*/
  

  Catch
  printf("\nrun time: %s (%s)\n", ExeTm.GetTmStr(), TSecTm::GetCurTm().GetTmStr().CStr());
  return 0;
}
